<?php
session_start();

define('ADMIN_PASSWORD', '123456');
define('DATA_FILE', __DIR__ . '/data.json');
define('ICONS_DIR', __DIR__ . '/icons/');
define('IMAGES_DIR', __DIR__ . '/images/');

// ... (登录、登出、背景图等PHP逻辑与上一版完全相同) ...
if (isset($_POST['password'])) { if ($_POST['password'] === ADMIN_PASSWORD) { $_SESSION['is_admin'] = true; header('Location: index.php?admin'); exit; } else { $login_error = "密码错误！"; } }
if (isset($_GET['action']) && $_GET['action'] === 'logout') { session_destroy(); header('Location: index.php?admin'); exit; }
$wallpaper_count = count(glob(IMAGES_DIR . 'background*.jpg'));
$random_bg_num = $wallpaper_count > 0 ? rand(1, $wallpaper_count) : 0;
$random_bg_url = $random_bg_num > 0 ? "images/background{$random_bg_num}.jpg" : '';

if (!isset($_SESSION['is_admin']) || $_SESSION['is_admin'] !== true) {
    // ... (登录页HTML与上一版完全相同) ...
    ?>
    <!DOCTYPE html><html lang="zh-CN"><head><meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1.0"><title>后台登录</title><script src="https://cdn.tailwindcss.com"></script><style>body::before{content:"";position:fixed;top:0;left:0;width:100%;height:100%;background:url('<?= $random_bg_url ?>' ) no-repeat center center;background-size:cover;z-index:-1;}</style></head><body class="text-white flex items-center justify-center min-h-screen"><div class="bg-gray-900 bg-opacity-70 backdrop-filter backdrop-blur-md p-8 rounded-lg shadow-lg w-full max-w-sm"><h1 class="text-2xl font-bold text-center mb-6">后台管理登录</h1><?php if(isset($login_error)): ?><div class="bg-red-500 text-white p-3 rounded-md mb-4 text-center"><?= htmlspecialchars($login_error) ?></div><?php endif; ?><form method="POST" action="index.php?admin"><div class="mb-4"><label for="password" class="block mb-2">密码</label><input type="password" name="password" id="password" class="w-full bg-gray-700 border border-gray-600 rounded-md p-2 focus:outline-none focus:ring-2 focus:ring-blue-500" required></div><button type="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-md transition">登录</button></form></div><script src="core.js"></script></body></html>
    <?php
    exit;
}

function get_data() { if (!file_exists(DATA_FILE)) return null; return json_decode(file_get_contents(DATA_FILE), true); }
function save_data($data) { return file_put_contents(DATA_FILE, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)); }
function handle_icon_upload($file_input_name, $title) { if (isset($_FILES[$file_input_name]) && $_FILES[$file_input_name]['error'] === UPLOAD_ERR_OK) { if (!is_dir(ICONS_DIR)) mkdir(ICONS_DIR, 0755, true); $allowed_types = ['image/x-icon', 'image/vnd.microsoft.icon', 'image/png']; if (!in_array($_FILES[$file_input_name]['type'], $allowed_types)) return "图标格式必须是 .ico 或 .png！"; $icon_path = ICONS_DIR . rawurlencode($title) . '.ico'; if (move_uploaded_file($_FILES[$file_input_name]['tmp_name'], $icon_path)) return true; else return "移动上传的图标文件失败！"; } return false; }
function fetch_favicon($url, $title) { if (!is_dir(ICONS_DIR)) mkdir(ICONS_DIR, 0755, true); $domain = parse_url($url, PHP_URL_HOST); if (!$domain) return false; $icon_urls = ["https://{$domain}/favicon.ico", "https://{$domain}/apple-touch-icon.png", "https://www.google.com/s2/favicons?domain={$domain}&sz=128"]; $icon_path = ICONS_DIR . rawurlencode($title ) . '.ico'; foreach ($icon_urls as $icon_url) { try { $ch = curl_init($icon_url); curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); curl_setopt($ch, CURLOPT_TIMEOUT, 5); curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); $content = curl_exec($ch); $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE ); curl_close($ch); if ($http_code === 200 && $content && strlen($content ) > 100) { file_put_contents($icon_path, $content); return true; } } catch (Exception $e) { continue; } } return false; }

// ########## PRG模式核心改动 ##########
// 1. 将消息处理移到所有POST逻辑之前
$message = $_SESSION['message'] ?? '';
$error = $_SESSION['error'] ?? '';
unset($_SESSION['message'], $_SESSION['error']); // 取出消息后立即销毁，确保只显示一次

// 2. 处理POST请求
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = get_data();
    
    if (isset($_POST['action']) && $_POST['action'] === 'update_global') {
        $data['mainTitle'] = $_POST['mainTitle']; $data['subTitle'] = $_POST['subTitle']; $data['useCustomFont'] = isset($_POST['useCustomFont']);
        if (save_data($data)) $_SESSION['message'] = "全局设置已更新！";
        else $_SESSION['error'] = "无法写入 data.json 文件，请检查权限！";
    }
    if (isset($_POST['action']) && $_POST['action'] === 'add_website') {
        $new_title = $_POST['title']; $new_website = ['title' => $new_title, 'description' => $_POST['description'], 'url' => $_POST['url']]; $data['websites'][] = $new_website;
        if (save_data($data)) {
            $upload_result = handle_icon_upload('icon', $new_title);
            if ($upload_result === true) $_SESSION['message'] = "网站 '{$new_title}' 已添加，并使用了上传的图标！";
            elseif (is_string($upload_result)) $_SESSION['error'] = $upload_result;
            else { fetch_favicon($new_website['url'], $new_title); $_SESSION['message'] = "网站 '{$new_title}' 已添加，并已尝试自动获取图标。"; }
        } else $_SESSION['error'] = "添加网站失败！";
    }
    if (isset($_POST['action']) && $_POST['action'] === 'update_website') {
        $index = $_POST['index']; if (isset($data['websites'][$index])) {
            $old_title = $data['websites'][$index]['title']; $new_title = $_POST['title']; $data['websites'][$index] = ['title' => $new_title, 'description' => $_POST['description'], 'url' => $_POST['url']];
            if (save_data($data)) {
                if ($old_title !== $new_title && file_exists(ICONS_DIR . rawurlencode($old_title) . '.ico')) { rename(ICONS_DIR . rawurlencode($old_title) . '.ico', ICONS_DIR . rawurlencode($new_title) . '.ico'); }
                $upload_result = handle_icon_upload('edit_icon', $new_title);
                if ($upload_result === true) $_SESSION['message'] = "网站 '{$new_title}' 已更新，并使用了新上传的图标！";
                elseif (is_string($upload_result)) $_SESSION['error'] = $upload_result;
                else { fetch_favicon($_POST['url'], $new_title); $_SESSION['message'] = "网站 '{$new_title}' 已更新！"; }
            } else $_SESSION['error'] = "更新网站失败！";
        }
    }
    if (isset($_POST['action']) && $_POST['action'] === 'delete_website') {
        $index = $_POST['index']; if (isset($data['websites'][$index])) {
            $deleted_title = $data['websites'][$index]['title']; if (file_exists(ICONS_DIR . rawurlencode($deleted_title) . '.ico')) { @unlink(ICONS_DIR . rawurlencode($deleted_title) . '.ico'); }
            array_splice($data['websites'], $index, 1);
            if (save_data($data)) $_SESSION['message'] = "网站 '{$deleted_title}' 已删除！";
            else $_SESSION['error'] = "删除网站失败！";
        }
    }
    if (isset($_POST['action']) && $_POST['action'] === 'upload_wallpaper') {
        if (isset($_FILES['wallpaper']) && $_FILES['wallpaper']['error'] === UPLOAD_ERR_OK) {
            if (!is_dir(IMAGES_DIR)) mkdir(IMAGES_DIR, 0755, true); $files = glob(IMAGES_DIR . 'background*.jpg'); $next_num = count($files) + 1; $new_filename = 'background' . $next_num . '.jpg';
            if (move_uploaded_file($_FILES['wallpaper']['tmp_name'], IMAGES_DIR . $new_filename)) $_SESSION['message'] = "壁纸 '{$new_filename}' 上传成功！";
            else $_SESSION['error'] = "上传失败，请检查 'images' 文件夹的写入权限。";
        } else $_SESSION['error'] = "上传出错，请选择一个有效的图片文件。";
    }
    
    // 3. 所有POST处理完后，立即重定向！
    header('Location: index.php?admin');
    exit;
}

// 如果不是POST请求，正常加载页面数据
$data = get_data();
$wallpapers = [];
if (is_dir(IMAGES_DIR)) { $files = scandir(IMAGES_DIR); foreach ($files as $file) { if (preg_match('/^background\d+\.jpg$/i', $file)) { $wallpapers[] = $file; } } }
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <!-- ... (head部分与上一版完全相同) ... -->
    <meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1.0"><title>后台管理</title><script src="https://cdn.tailwindcss.com"></script>
    <style>
        .modal{display:none;}.modal.active{display:flex;}
        body::before{content:"";position:fixed;top:0;left:0;width:100%;height:100%;background:url('<?= $random_bg_url ?>' ) no-repeat center center;background-size:cover;z-index:-1;filter:brightness(0.5);}
        .wallpaper-item.hidden-item{display:none;}
        .truncate-text { white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
    </style>
</head>
<body class="bg-transparent text-gray-200">
    <div class="container mx-auto p-4 md:p-8">
        <header class="flex justify-between items-center mb-8"><h1 class="text-3xl font-bold">后台管理面板</h1><a href="index.php?admin&action=logout" class="bg-red-600 hover:bg-red-700 text-white font-bold py-2 px-4 rounded-md transition">安全退出</a></header>
        
        <!-- 消息显示区域现在使用从Session取出的变量 -->
        <?php if ($message): ?><div class="bg-green-600 bg-opacity-80 text-white p-3 rounded-md mb-6"><?= htmlspecialchars($message) ?></div><?php endif; ?>
        <?php if ($error): ?><div class="bg-red-500 bg-opacity-80 text-white p-3 rounded-md mb-6"><?= htmlspecialchars($error) ?></div><?php endif; ?>

        <!-- ... (所有HTML内容，包括全局设置、网站管理卡片、壁纸管理、弹窗等，都与上一版完全相同) ... -->
        <section class="bg-gray-800 bg-opacity-70 backdrop-filter backdrop-blur-md p-6 rounded-lg shadow-lg mb-8">
            <h2 class="text-2xl font-semibold mb-4">全局设置</h2>
            <form method="POST" action="index.php?admin"><input type="hidden" name="action" value="update_global"><div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4"><div><label for="mainTitle" class="block mb-2">网站主标题</label><input type="text" name="mainTitle" id="mainTitle" value="<?= htmlspecialchars($data['mainTitle'] ?? '') ?>" class="w-full bg-gray-700 border border-gray-600 rounded-md p-2"></div><div><label for="subTitle" class="block mb-2">网站副标题 / 简介</label><input type="text" name="subTitle" id="subTitle" value="<?= htmlspecialchars($data['subTitle'] ?? '') ?>" class="w-full bg-gray-700 border border-gray-600 rounded-md p-2"></div></div><div class="mb-4"><label class="flex items-center"><input type="checkbox" name="useCustomFont" class="form-checkbox h-5 w-5 bg-gray-700 border-gray-600 rounded text-blue-500 focus:ring-blue-500" <?= !isset($data['useCustomFont']) || $data['useCustomFont'] ? 'checked' : '' ?>><span class="ml-2">使用自定义字体 (1.woff2)</span></label></div><button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-md">保存全局设置</button></form>
        </section>
        <section class="bg-gray-800 bg-opacity-70 backdrop-filter backdrop-blur-md p-6 rounded-lg shadow-lg mb-8">
            <div class="flex justify-between items-center mb-4"><h2 class="text-2xl font-semibold">网站管理</h2><button onclick="openModal('add-modal')" class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded-md">添加新网站</button></div>
            <div class="grid grid-cols-1 lg:grid-cols-2 xl:grid-cols-3 gap-4">
                <?php if (!empty($data['websites'])): foreach ($data['websites'] as $index => $site): ?>
                <div class="bg-gray-900/50 rounded-lg p-4 flex flex-col justify-between">
                    <div><div class="flex items-start justify-between mb-3"><div class="flex items-center min-w-0"><img src="icons/<?= rawurlencode($site['title']) ?>.ico?t=<?= time() ?>" alt="logo" class="w-10 h-10 rounded-md bg-gray-700 mr-3 flex-shrink-0" onerror="this.src='data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7'"><h3 class="text-lg font-semibold truncate-text" title="<?= htmlspecialchars($site['title']) ?>"><?= htmlspecialchars($site['title']) ?></h3></div></div><p class="text-sm text-gray-400 mb-2 truncate-text" title="<?= htmlspecialchars($site['description']) ?>">简介: <?= htmlspecialchars($site['description']) ?></p><p class="text-sm text-blue-400 truncate-text" title="<?= htmlspecialchars($site['url']) ?>"><a href="<?= htmlspecialchars($site['url']) ?>" target="_blank">网址: <?= htmlspecialchars($site['url']) ?></a></p></div>
                    <div class="flex justify-end items-center mt-4"><button onclick='openModal("edit-modal", <?= json_encode($site, JSON_HEX_APOS) ?>, <?= $index ?>)' class="text-blue-400 hover:text-blue-300 mr-4 font-medium">编辑</button><form method="POST" action="index.php?admin" class="inline-block" onsubmit="return confirm('确定要删除 \'<?= htmlspecialchars($site['title']) ?>\' 吗？')"><input type="hidden" name="action" value="delete_website"><input type="hidden" name="index" value="<?= $index ?>"><button type="submit" class="text-red-400 hover:text-red-300 font-medium">删除</button></form></div>
                </div>
                <?php endforeach; else: ?><p class="col-span-full text-center text-gray-400 py-8">暂无网站，请点击右上角添加一个新网站。</p><?php endif; ?>
            </div>
        </section>
        <section class="bg-gray-800 bg-opacity-70 backdrop-filter backdrop-blur-md p-6 rounded-lg shadow-lg">
            <div class="flex justify-between items-center mb-4"><h2 class="text-2xl font-semibold">壁纸库管理</h2><?php if (count($wallpapers) > 6): ?><button id="toggle-wallpapers" class="bg-gray-600 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded-md">展开全部</button><?php endif; ?></div>
            <div class="mb-6"><h3 class="font-semibold mb-2">上传新壁纸 (.jpg):</h3><form method="POST" action="index.php?admin" enctype="multipart/form-data"><input type="hidden" name="action" value="upload_wallpaper"><div class="flex items-center"><input type="file" name="wallpaper" accept=".jpg,.jpeg" class="block w-full text-sm text-gray-400 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm file:font-semibold file:bg-blue-600 file:text-white hover:file:bg-blue-700"><button type="submit" class="ml-4 bg-purple-600 hover:bg-purple-700 text-white font-bold py-2 px-4 rounded-md whitespace-nowrap">上传</button></div></form></div>
            <div><h3 class="font-semibold mb-2">当前壁纸列表 (共 <?= count($wallpapers) ?> 张):</h3><div id="wallpaper-grid" class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-6 gap-4">
            <?php foreach ($wallpapers as $index => $wallpaper): ?>
            <div class="wallpaper-item <?= $index >= 6 ? 'hidden-item' : '' ?>"><img src="images/<?= htmlspecialchars($wallpaper) ?>?t=<?= time() ?>" alt="<?= htmlspecialchars($wallpaper) ?>" class="w-full h-24 object-cover rounded-md mb-2"><p class="text-sm text-gray-400"><?= htmlspecialchars($wallpaper) ?></p></div>
            <?php endforeach; ?>
            </div></div>
        </section>
    </div>
    <div id="add-modal" class="modal fixed inset-0 bg-black bg-opacity-75 items-center justify-center p-4"><div class="bg-gray-800 p-6 rounded-lg shadow-lg w-full max-w-md"><h2 class="text-2xl font-semibold mb-4">添加新网站</h2><form method="POST" action="index.php?admin" enctype="multipart/form-data"><input type="hidden" name="action" value="add_website"><div class="mb-4"><label for="add-title" class="block mb-2">名称</label><input type="text" name="title" id="add-title" class="w-full bg-gray-700 border border-gray-600 rounded-md p-2" required></div><div class="mb-4"><label for="add-url" class="block mb-2">网址 (URL)</label><input type="url" name="url" id="add-url" placeholder="https://example.com" class="w-full bg-gray-700 border border-gray-600 rounded-md p-2" required></div><div class="mb-4"><label for="add-description" class="block mb-2">简介</label><textarea name="description" id="add-description" rows="2" class="w-full bg-gray-700 border border-gray-600 rounded-md p-2"></textarea></div><div class="mb-4"><label for="add-icon" class="block mb-2">自定义图标 (可选, .ico/.png )</label><input type="file" name="icon" id="add-icon" accept=".ico,.png" class="block w-full text-sm text-gray-400 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm file:font-semibold file:bg-gray-600 file:text-white hover:file:bg-gray-700"></div><div class="flex justify-end gap-4"><button type="button" onclick="closeModal('add-modal')" class="bg-gray-600 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded-md">取消</button><button type="submit" class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded-md">确认添加</button></div></form></div></div>
    <div id="edit-modal" class="modal fixed inset-0 bg-black bg-opacity-75 items-center justify-center p-4"><div class="bg-gray-800 p-6 rounded-lg shadow-lg w-full max-w-md"><h2 class="text-2xl font-semibold mb-4">编辑网站</h2><form method="POST" action="index.php?admin" enctype="multipart/form-data"><input type="hidden" name="action" value="update_website"><input type="hidden" name="index" id="edit-index"><div class="mb-4"><label for="edit-title" class="block mb-2">名称</label><input type="text" name="title" id="edit-title" class="w-full bg-gray-700 border border-gray-600 rounded-md p-2" required></div><div class="mb-4"><label for="edit-url" class="block mb-2">网址 (URL)</label><input type="url" name="url" id="edit-url" class="w-full bg-gray-700 border border-gray-600 rounded-md p-2" required></div><div class="mb-4"><label for="edit-description" class="block mb-2">简介</label><textarea name="description" id="edit-description" rows="2" class="w-full bg-gray-700 border border-gray-600 rounded-md p-2"></textarea></div><div class="mb-4"><label for="edit-icon" class="block mb-2">上传新图标 (可选, 留空则不修改)</label><input type="file" name="edit_icon" id="edit-icon" accept=".ico,.png" class="block w-full text-sm text-gray-400 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm file:font-semibold file:bg-gray-600 file:text-white hover:file:bg-gray-700"></div><div class="flex justify-end gap-4"><button type="button" onclick="closeModal('edit-modal')" class="bg-gray-600 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded-md">取消</button><button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-md">保存更改</button></div></form></div></div>
    <script>
        function openModal(modalId, data = null, index = null) { const modal = document.getElementById(modalId); if (modalId === 'edit-modal' && data && index !== null) { document.getElementById('edit-index').value = index; document.getElementById('edit-title').value = data.title; document.getElementById('edit-url').value = data.url; document.getElementById('edit-description').value = data.description; } modal.classList.add('active'); }
        function closeModal(modalId) { document.getElementById(modalId).classList.remove('active'); }
        const toggleBtn = document.getElementById('toggle-wallpapers'); if (toggleBtn) { toggleBtn.addEventListener('click', function() { const hiddenItems = document.querySelectorAll('.wallpaper-item.hidden-item'); const isHidden = this.textContent === '展开全部'; hiddenItems.forEach(item => { item.style.display = isHidden ? 'block' : 'none'; }); this.textContent = isHidden ? '收起' : '展开全部'; }); }
    </script>
    <script src="core.js"></script>
</body>
</html>
<?php
exit;
?>
