<?php
require_once "config.php";
session_start(); // 必须置顶，无任何前置输出

// 严格校验登录状态：未登录则强制跳登录页
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>后台管理</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: url('https://www.qhdh.top/png/background3.jpg') no-repeat center center fixed;
            background-size: cover;
            color: #fff;
            font-family: 'Microsoft YaHei', sans-serif;
        }

        .container {
            display: flex;
            height: 100vh;
        }

        .sidebar {
            width: 200px;
            background: rgba(255, 255, 255, 0.1);
            padding: 20px;
        }

        .sidebar h2 {
            text-align: center;
            margin-bottom: 30px;
        }

        .sidebar ul {
            list-style: none;
        }

        .sidebar ul li {
            margin-bottom: 10px;
        }

        .sidebar ul li a {
            color: #fff;
            text-decoration: none;
            display: block;
            padding: 10px;
            border-radius: 5px;
            transition: background 0.3s;
        }

        .sidebar ul li a:hover, .sidebar ul li a.active {
            background: rgba(255, 255, 255, 0.2);
        }

        .main-content {
            flex: 1;
            padding: 20px;
            overflow-y: auto;
        }

        .form-container {
            background: rgba(255, 255, 255, 0.1);
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 20px;
        }

        .form-container h3 {
            margin-bottom: 20px;
        }

        .form-group {
            margin-bottom: 15px;
        }

        .form-group label {
            display: block;
            margin-bottom: 5px;
        }

        .form-group input, .form-group textarea, .form-group select {
            width: 100%;
            padding: 10px;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 5px;
            color: #fff;
        }

        .btn {
            padding: 10px 20px;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 5px;
            color: #fff;
            cursor: pointer;
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
        }

        .btn:hover {
            background: rgba(255, 255, 255, 0.2);
        }

        .tab-content {
            display: none;
        }

        .tab-content.active {
            display: block;
        }

        .link-item, .line-item {
            display: flex;
            align-items: center;
            margin-bottom: 10px;
        }

        .link-item input, .line-item input {
            flex: 1;
            margin-right: 10px;
            margin-bottom: 0;
            padding: 10px;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 5px;
            color: #fff;
        }

        .del-btn {
            padding: 5px 10px;
            background: rgba(255, 0, 0, 0.5);
            border: none;
            border-radius: 5px;
            color: #fff;
            cursor: pointer;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="sidebar">
            <h2>后台管理</h2>
            <ul>
                <li><a href="#" class="active" onclick="showTab('site-settings')">网站设置</a></li>
                <li><a href="#" onclick="showTab('line-management')">线路管理</a></li>
                <li><a href="#" onclick="showTab('friend-links')">友情链接</a></li>
                <li><a href="#" onclick="showTab('nav-links')">导航管理</a></li>
                <li><a href="#" onclick="showTab('record-info')">备案信息</a></li>
                <li><a href="#" onclick="logout()">退出登录</a></li>
            </ul>
        </div>

        <div class="main-content">
            <div id="site-settings" class="tab-content active">
                <div class="form-container">
                    <h3>网站设置</h3>
                    <form onsubmit="saveSettings(event)">
                        <div class="form-group">
                            <label for="site-name">网站名称</label>
                            <input type="text" id="site-name" name="site-name" value="视频解析">
                        </div>
                        <div class="form-group">
                            <label for="site-logo">网站Logo</label>
                            <input type="text" id="site-logo" name="site-logo" placeholder="Logo URL">
                        </div>
                        <div class="form-group">
                            <label for="background-image">背景图片</label>
                            <input type="text" id="background-image" name="background-image" value="https://www.qhdh.top/png/background3.jpg">
                        </div>
                        <div class="form-group">
                            <label for="site-description">网站描述</label>
                            <textarea id="site-description" name="site-description" rows="3"></textarea>
                        </div>
                        <button type="submit" class="btn">保存设置</button>
                    </form>
                </div>
            </div>

            <div id="line-management" class="tab-content">
                <div class="form-container">
                    <h3>线路管理</h3>
                    <div id="lines-container">
                        <div class="line-item">
                            <input type="text" placeholder="线路名称" value="线路1">
                            <input type="text" placeholder="线路API">
                            <button class="del-btn" onclick="deleteLine(this)">删除</button>
                        </div>
                        <div class="line-item">
                            <input type="text" placeholder="线路名称" value="线路2">
                            <input type="text" placeholder="线路API">
                            <button class="del-btn" onclick="deleteLine(this)">删除</button>
                        </div>
                        <div class="line-item">
                            <input type="text" placeholder="线路名称" value="线路3">
                            <input type="text" placeholder="线路API">
                            <button class="del-btn" onclick="deleteLine(this)">删除</button>
                        </div>
                    </div>
                    <button class="btn" onclick="addLine()">添加线路</button>
                    <button class="btn" onclick="saveLines()">保存线路</button>
                </div>
            </div>

            <div id="friend-links" class="tab-content">
                <div class="form-container">
                    <h3>友情链接</h3>
                    <div id="links-container">
                        <div class="link-item">
                            <input type="text" placeholder="链接名称" value="百度">
                            <input type="text" placeholder="链接URL" value="https://www.baidu.com">
                            <button class="del-btn" onclick="deleteLink(this)">删除</button>
                        </div>
                        <div class="link-item">
                            <input type="text" placeholder="链接名称" value="谷歌">
                            <input type="text" placeholder="链接URL" value="https://www.google.com">
                            <button class="del-btn" onclick="deleteLink(this)">删除</button>
                        </div>
                    </div>
                    <button class="btn" onclick="addLink()">添加链接</button>
                    <button class="btn" onclick="saveLinks()">保存链接</button>
                </div>
            </div>

            <div id="nav-links" class="tab-content">
                <div class="form-container">
                    <h3>导航管理</h3>
                    <div id="nav-links-container">
                        <div class="link-item">
                            <input type="text" placeholder="链接名称" value="首页">
                            <input type="text" placeholder="链接URL" value="#">
                            <button class="del-btn" onclick="deleteNavLink(this)">删除</button>
                        </div>
                        <div class="link-item">
                            <input type="text" placeholder="链接名称" value="使用帮助">
                            <input type="text" placeholder="链接URL" value="#">
                            <button class="del-btn" onclick="deleteNavLink(this)">删除</button>
                        </div>
                         <div class="link-item">
                            <input type="text" placeholder="链接名称" value="关于我们">
                            <input type="text" placeholder="链接URL" value="#">
                            <button class="del-btn" onclick="deleteNavLink(this)">删除</button>
                        </div>
                    </div>
                    <button class="btn" onclick="addNavLink()">添加链接</button>
                    <button class="btn" onclick="saveNavLinks()">保存链接</button>
                </div>
            </div>

            <div id="record-info" class="tab-content">
                <div class="form-container">
                    <h3>备案信息</h3>
                    <form onsubmit="saveRecordInfo(event)">
                        <div class="form-group">
                            <label for="record-number">备案号</label>
                            <input type="text" id="record-number" name="record-number" value="京ICP备12345678号">
                        </div>
                        <button type="submit" class="btn">保存信息</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        // 检查登录状态
        document.addEventListener('DOMContentLoaded', function() {
            fetch('check_login.php', {
                method: 'GET',
            })
            .then(response => response.json())
            .then(data => {
                if (!data.loggedIn) {
                    window.location.href = 'login.php';
                } else {
                    // 登录成功后加载配置
                    loadConfig();
                }
            })
            .catch((error) => {
                console.error('Error:', error);
                window.location.href = 'login.php';
            });
        });

        function loadConfig() {
            fetch('get_config.php')
                .then(response => {
                    if (!response.ok) {
                        throw new Error('Network response was not ok');
                    }
                    return response.json();
                })
                .then(config => {
                    // 填充网站设置表单
                    document.getElementById('site-name').value = config.siteName || '视频解析';
                    document.getElementById('site-logo').value = config.siteLogo || '';
                    document.getElementById('site-description').value = config.siteDescription || '';
                    document.getElementById('background-image').value = config.backgroundImage || 'https://www.qhdh.top/png/background3.jpg';
                    document.getElementById('record-number').value = config.recordInfo || '京ICP备12345678号';

                    // 加载线路
                    const linesContainer = document.getElementById('lines-container');
                    linesContainer.innerHTML = '';
                    if (config.lines && config.lines.length > 0) {
                        config.lines.forEach(line => {
                            const lineItem = document.createElement('div');
                            lineItem.className = 'line-item';
                            lineItem.innerHTML = `
                                <input type="text" placeholder="线路名称" value="${line.name || ''}">
                                <input type="text" placeholder="线路API" value="${line.api || ''}">
                                <button class="del-btn" onclick="deleteLine(this)">删除</button>
                            `;
                            linesContainer.appendChild(lineItem);
                        });
                    } else {
                        // 如果没有线路，添加一些默认的空行
                        for (let i = 0; i < 3; i++) {
                            const lineItem = document.createElement('div');
                            lineItem.className = 'line-item';
                            lineItem.innerHTML = `
                                <input type="text" placeholder="线路名称" value="线路${i+1}">
                                <input type="text" placeholder="线路API">
                                <button class="del-btn" onclick="deleteLine(this)">删除</button>
                            `;
                            linesContainer.appendChild(lineItem);
                        }
                    }

                    // 加载友情链接
                    const linksContainer = document.getElementById('links-container');
                    linksContainer.innerHTML = '';
                    if (config.friendLinks && config.friendLinks.length > 0) {
                        config.friendLinks.forEach(link => {
                            const linkItem = document.createElement('div');
                            linkItem.className = 'link-item';
                            linkItem.innerHTML = `
                                <input type="text" placeholder="链接名称" value="${link.name || ''}">
                                <input type="text" placeholder="链接URL" value="${link.url || ''}">
                                <button class="del-btn" onclick="deleteLink(this)">删除</button>
                            `;
                            linksContainer.appendChild(linkItem);
                        });
                    } else {
                        // 如果没有友情链接，添加一些默认的
                        const defaultLinks = [
                            { name: '百度', url: 'https://www.baidu.com' },
                            { name: '谷歌', url: 'https://www.google.com' }
                        ];
                        defaultLinks.forEach(link => {
                            const linkItem = document.createElement('div');
                            linkItem.className = 'link-item';
                            linkItem.innerHTML = `
                                <input type="text" placeholder="链接名称" value="${link.name}">
                                <input type="text" placeholder="链接URL" value="${link.url}">
                                <button class="del-btn" onclick="deleteLink(this)">删除</button>
                            `;
                            linksContainer.appendChild(linkItem);
                        });
                    }
                })
                .catch((error) => {
                    console.error('Error:', error);
                });
        }

        function showTab(tabName) {
            const tabContents = document.getElementsByClassName('tab-content');
            for (let i = 0; i < tabContents.length; i++) {
                tabContents[i].classList.remove('active');
            }

            const tabs = document.querySelectorAll('.sidebar ul li a');
            for (let i = 0; i < tabs.length; i++) {
                tabs[i].classList.remove('active');
            }

            document.getElementById(tabName).classList.add('active');
            event.currentTarget.classList.add('active');
        }

        function saveSettings(event) {
            event.preventDefault();
            const siteName = document.getElementById('site-name').value;
            const siteLogo = document.getElementById('site-logo').value;
            const siteDescription = document.getElementById('site-description').value;
            const backgroundImage = document.getElementById('background-image').value;

            // 发送请求到后端保存设置
            fetch('save_settings.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    siteName,
                    siteLogo,
                    siteDescription,
                    backgroundImage
                }),
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('网站设置已保存');
                } else {
                    alert('保存失败：' + data.message);
                }
            })
            .catch((error) => {
                console.error('Error:', error);
                alert('保存失败');
            });
        }

        function addLine() {
            const container = document.getElementById('lines-container');
            const lineItem = document.createElement('div');
            lineItem.className = 'line-item';
            lineItem.innerHTML = `
                <input type="text" placeholder="线路名称">
                <input type="text" placeholder="线路API">
                <button class="del-btn" onclick="deleteLine(this)">删除</button>
            `;
            container.appendChild(lineItem);
        }

        function deleteLine(btn) {
            btn.parentElement.remove();
        }

        function saveLines() {
            const lines = [];
            document.querySelectorAll('.line-item').forEach(item => {
                const inputs = item.querySelectorAll('input');
                lines.push({
                    name: inputs[0].value,
                    api: inputs[1].value
                });
            });

            fetch('save_lines.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({ lines }),
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('线路已保存');
                } else {
                    alert('保存失败：' + data.message);
                }
            })
            .catch((error) => {
                console.error('Error:', error);
                alert('保存失败');
            });
        }

        function addLink() {
            const container = document.getElementById('links-container');
            const linkItem = document.createElement('div');
            linkItem.className = 'link-item';
            linkItem.innerHTML = `
                <input type="text" placeholder="链接名称">
                <input type="text" placeholder="链接URL">
                <button class="del-btn" onclick="deleteLink(this)">删除</button>
            `;
            container.appendChild(linkItem);
        }

        function deleteLink(btn) {
            btn.parentElement.remove();
        }

        function saveLinks() {
            const links = [];
            document.querySelectorAll('.link-item').forEach(item => {
                const inputs = item.querySelectorAll('input');
                links.push({
                    name: inputs[0].value,
                    url: inputs[1].value
                });
            });

            fetch('save_links.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({ links }),
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('友情链接已保存');
                } else {
                    alert('保存失败：' + data.message);
                }
            })
            .catch((error) => {
                console.error('Error:', error);
                alert('保存失败');
            });
        }

        function saveNavLinks() {
            const links = [];
            document.querySelectorAll('#nav-links-container .link-item').forEach(item => {
                const inputs = item.querySelectorAll('input');
                links.push({
                    name: inputs[0].value,
                    url: inputs[1].value
                });
            });

            fetch('save_nav_links.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({ links }),
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('导航链接已保存');
                } else {
                    alert('保存失败：' + data.message);
                }
            })
            .catch((error) => {
                console.error('Error:', error);
                alert('保存失败');
            });
        }

        function addNavLink() {
            const container = document.getElementById('nav-links-container');
            const linkItem = document.createElement('div');
            linkItem.className = 'link-item';
            linkItem.innerHTML = `
                <input type="text" placeholder="链接名称">
                <input type="text" placeholder="链接URL">
                <button class="del-btn" onclick="deleteNavLink(this)">删除</button>
            `;
            container.appendChild(linkItem);
        }

        function deleteNavLink(btn) {
            btn.parentElement.remove();
        }

        function saveRecordInfo(event) {
            event.preventDefault();
            const recordNumber = document.getElementById('record-number').value;

            fetch('save_record_info.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({ recordNumber }),
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('备案信息已保存');
                } else {
                    alert('保存失败：' + data.message);
                }
            })
            .catch((error) => {
                console.error('Error:', error);
                alert('保存失败');
            });
        }

        function logout() {
            // 清除session并跳转登录页
            fetch('logout.php', { method: 'GET' })
            .then(() => {
                window.location.href = 'login.php';
            });
        }
    </script>
</body>
</html>