<?php
/**
 * 视频解析网站安装程序
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

$lock_file = 'install.lock';
if (file_exists($lock_file)) {
    die('系统已安装，如需重新安装请删除 install.lock 文件。');
}

$step = isset($_GET['step']) ? intval($_GET['step']) : 1;

if ($_SERVER['REQUEST_METHOD'] == 'POST' && $step == 2) {
    $db_host = trim($_POST['db_host']);
    $db_user = trim($_POST['db_user']);
    $db_pass = trim($_POST['db_pass']);
    $db_name = trim($_POST['db_name']);
    $admin_user = trim($_POST['admin_user']);
    $admin_pass = trim($_POST['admin_pass']);

    // 1. 尝试连接数据库服务器
    $conn = @new mysqli($db_host, $db_user, $db_pass);
    
    if ($conn->connect_error) {
        $error = "数据库连接失败！<br>错误信息: " . $conn->connect_error . "<br><br>提示：请确保数据库地址、用户名和密码填写正确。通常地址为 localhost 或 127.0.0.1。";
    } else {
        // 2. 创建数据库（如果不存在）
        $conn->query("CREATE DATABASE IF NOT EXISTS `$db_name` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci");
        
        if (!$conn->select_db($db_name)) {
            $error = "无法选择或创建数据库: " . $conn->error;
        } else {
            // 3. 导入 SQL
            $sql_file = 'install.sql';
            if (!file_exists($sql_file)) {
                $error = "安装文件 install.sql 不存在，请检查源码包是否完整。";
            } else {
                $sql_content = file_get_contents($sql_file);
                // 简单的 SQL 分割逻辑
                $queries = preg_split("/;[\r\n]+/", $sql_content);
                foreach ($queries as $query) {
                    $query = trim($query);
                    if (!empty($query)) {
                        $conn->query($query);
                    }
                }

                // 4. 更新管理员账号
                $hashed_pass = password_hash($admin_pass, PASSWORD_DEFAULT);
                $conn->query("DELETE FROM `admin_users` WHERE 1");
                $stmt = $conn->prepare("INSERT INTO `admin_users` (username, password) VALUES (?, ?)");
                $stmt->bind_param("ss", $admin_user, $hashed_pass);
                $stmt->execute();

                // 5. 写入配置文件
                $config_template = "<?php
/**
 * 数据库配置文件
 * 由安装程序自动生成
 */

define('DB_HOST', '$db_host');
define('DB_USER', '$db_user');
define('DB_PASS', '$db_pass');
define('DB_NAME', '$db_name');

function get_db_connection() {
    \$conn = @new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    if (\$conn->connect_error) {
        die(\"<div style='padding:20px; background:#fff5f5; color:#c53030; border:1px solid #feb2b2; border-radius:5px; margin:20px; font-family:sans-serif;'>
                <h3 style='margin-top:0;'>数据库连接失败</h3>
                <p>错误详情: \" . \$conn->connect_error . \"</p>
                <p>请检查 <b>config.php</b> 中的数据库配置是否正确。</p>
             </div>\");
    }
    \$conn->set_charset('utf8mb4');
    return \$conn;
}
?>";
                file_put_contents('config.php', $config_template);

                // 6. 创建锁定文件
                file_put_contents($lock_file, date('Y-m-d H:i:s'));
                
                $success = true;
            }
        }
        $conn->close();
    }
}

?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>青禾视频解析网站 - 系统安装</title>
    <style>
        body { font-family: 'Microsoft YaHei', sans-serif; background: #f0f2f5; display: flex; justify-content: center; align-items: center; min-height: 100vh; margin: 0; }
        .install-box { background: #fff; padding: 40px; border-radius: 12px; box-shadow: 0 8px 30px rgba(0,0,0,0.08); width: 100%; max-width: 450px; }
        h2 { text-align: center; color: #1a1a1a; margin-bottom: 30px; font-weight: 600; }
        .form-group { margin-bottom: 20px; }
        label { display: block; margin-bottom: 8px; color: #4a4a4a; font-size: 14px; }
        input { width: 100%; padding: 12px; border: 1px solid #d9d9d9; border-radius: 6px; box-sizing: border-box; transition: all 0.3s; font-size: 15px; }
        input:focus { border-color: #40a9ff; outline: none; box-shadow: 0 0 0 2px rgba(24,144,255,0.2); }
        .btn { width: 100%; padding: 12px; background: #1890ff; border: none; color: #fff; border-radius: 6px; cursor: pointer; font-size: 16px; font-weight: 500; transition: background 0.3s; }
        .btn:hover { background: #40a9ff; }
        .error { color: #ff4d4f; background: #fff2f0; padding: 15px; border: 1px solid #ffccc7; border-radius: 6px; margin-bottom: 20px; font-size: 14px; line-height: 1.6; }
        .success { color: #52c41a; background: #f6ffed; padding: 20px; border: 1px solid #b7eb8f; border-radius: 6px; margin-bottom: 20px; text-align: center; }
        .tip { font-size: 12px; color: #8c8c8c; margin-top: 4px; }
        hr { border: 0; border-top: 1px solid #f0f0f0; margin: 25px 0; }
    </style>
</head>
<body>
    <div class="install-box">
        <h2>青禾vip视频解析系统安装</h2>
        
        <?php if (isset($error)): ?>
            <div class="error"><?php echo $error; ?></div>
        <?php endif; ?>

        <?php if (isset($success)): ?>
            <div class="success">
                <h3 style="margin-top:0">安装成功！</h3>
                <p style="font-size:14px; color:#666">为了系统安全，请务必手动删除 <b>install.php</b> 文件。</p>
                <div style="margin-top:20px">
                    <a href="index.php" style="display:inline-block; margin:0 10px; color: #1890ff; text-decoration: none;">进入首页</a>
                    <a href="hou.php" style="display:inline-block; margin:0 10px; color: #1890ff; text-decoration: none;">进入后台</a>
                </div>
            </div>
        <?php elseif ($step == 1): ?>
            <form action="?step=2" method="post">
                <div class="form-group">
                    <label>数据库地址</label>
                    <input type="text" name="db_host" value="localhost" placeholder="通常为 localhost" required>
                    <div class="tip">如果是本地数据库，请填写 localhost 或 127.0.0.1</div>
                </div>
                <div class="form-group">
                    <label>数据库用户名</label>
                    <input type="text" name="db_user" placeholder="数据库账号" required>
                </div>
                <div class="form-group">
                    <label>数据库密码</label>
                    <input type="password" name="db_pass" placeholder="数据库密码">
                </div>
                <div class="form-group">
                    <label>数据库名</label>
                    <input type="text" name="db_name" value="jiexi" placeholder="数据库名称" required>
                </div>
                <hr>
                <div class="form-group">
                    <label>管理员账号 (用于登录后台)</label>
                    <input type="text" name="admin_user" value="admin" required>
                </div>
                <div class="form-group">
                    <label>管理员密码</label>
                    <input type="password" name="admin_pass" placeholder="设置后台登录密码" required>
                </div>
                <button type="submit" class="btn">立即安装</button>
            </form>
        <?php endif; ?>
    </div>
</body>
</html>
