<?php
$coreJsPath = __DIR__ . '/core.js';
if (!file_exists($coreJsPath)) {
    header('HTTP/1.1 500 Internal Server Error');
    echo <<<HTML
<!DOCTYPE html><html lang="zh-CN"><head><meta charset="UTF-8"><title>错误</title><style>body{font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,sans-serif;background-color:#121212;color:#e0e0e0;display:flex;justify-content:center;align-items:center;height:100vh;margin:0;}.error-container{text-align:center;padding:40px;background-color:#1e1e1e;border-radius:12px;box-shadow:0 4px 20px rgba(0,0,0,0.5);}h1{color:#f87171;font-size:24px;margin-bottom:10px;}p{font-size:16px;}</style></head><body><div class="error-container"><h1>配置错误</h1><p>关键组件 'core.js' 缺失，无法加载页面。</p></div></body></html>
HTML;
    exit;
}

if (isset($_GET['admin'])) {
    if (file_exists(__DIR__ . '/admin.php')) { require_once __DIR__ . '/admin.php'; } 
    else { echo '<h1>错误</h1><p>后台文件 admin.php 不存在！</p>'; }
    exit;
}

$dataFile = __DIR__ . '/data.json';
$data = ['mainTitle' => '青禾网址发布页', 'subTitle' => '高效导航，便捷访问', 'websites' => [], 'useCustomFont' => true];
if (file_exists($dataFile)) {
    $jsonData = @json_decode(file_get_contents($dataFile), true);
    if (is_array($jsonData)) { $data = array_merge($data, $jsonData); }
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <?php if (!isset($data['useCustomFont']) || $data['useCustomFont']): ?>
    <link rel="preload" href="/1.woff2" as="font" type="font/woff2" crossorigin="anonymous">
    <?php endif; ?>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($data['mainTitle']) ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/lucide@0.544.0/dist/umd/lucide.min.js"></script>
    <script defer src="https://tj.qhdh.top/script.js" data-website-id="e6381377-638c-4c03-a191-060b468153f4"></script>
    <script src="core.js" defer></script>
    
    <style>
    <?php if (!isset($data['useCustomFont'] ) || $data['useCustomFont']): ?>
    @font-face {
        font-family: 'CustomSiteFont';
        src: url('/1.woff2') format('woff2'), url('/1.woff') format('woff');
        font-weight: normal; font-style: normal; font-display: swap;
    }
    * { font-family: 'CustomSiteFont', sans-serif !important; }
    body, h1, h2, h3, h4, h5, h6, p, a, span, input, button, textarea { font-family: 'CustomSiteFont', -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif !important; }
    <?php endif; ?>
    
    :root { --bg-image: url(''); --card-opacity: 0.1; --card-hover-opacity: 0.2; --btn-opacity: 0.05; --btn-hover-opacity: 0.15; --status-glow: 0 0 8px rgba(255, 255, 255, 0.6); }
    body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif; position: relative; min-height: 100vh; color: #e6e6e6; margin: 0; padding: 0; padding-bottom: 40px; }
    body::before { content: ""; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: var(--bg-image) no-repeat center center; background-size: cover; opacity: 1; z-index: -1; }
    .main-container { width: 50%; max-width: 1400px; margin: 0 auto; padding: 2rem 0; display: grid; grid-template-columns: repeat(3, 1fr); gap: 1.2rem; }
    .website-card { background: rgba(0, 0, 0, var(--card-opacity)); backdrop-filter: blur(12px); border: 1px solid rgba(0, 0, 0, var(--card-opacity)); border-radius: 12px; padding: 1rem 1.2rem; position: relative; display: flex; align-items: flex-start; gap: 1rem; transition: all 0.4s ease; box-shadow: 0 4px 15px rgba(0, 0, 0, 0.15); min-height: 120px; }
    .website-card:hover { background: rgba(0, 0, 0, var(--card-hover-opacity)); border-color: rgba(0, 0, 0, var(--card-hover-opacity)); transform: translateY(-6px); box-shadow: 0 8px 20px rgba(0, 0, 0, 0.25); }
    .website-icon { width: 36px; height: 36px; object-fit: contain; border-radius: 8px; background: transparent; flex-shrink: 0; padding: 3px; border: none; }
    .card-content { flex: 1; min-width: 0; padding: 0.1rem 0; }
    .website-title { font-size: 0.95rem; font-weight: 600; color: #ffffff; margin: 0 0 0.3rem 0; line-height: 1.2; }
    .website-desc { font-size: 0.7rem; color: #ededed; margin: 0; line-height: 1.3; max-width: 100%; }
    .status-indicator { display: inline-block; width: 8px; height: 8px; border-radius: 50%; margin-right: 4px; position: relative; }
    .status-online { background-color: #4ade80; box-shadow: 0 0 8px 2px rgba(74, 222, 128, 0.6); }
    .status-offline { background-color: #f87171; box-shadow: 0 0 8px 2px rgba(248, 113, 113, 0.6); }
    .status-checking { background-color: #facc15; box-shadow: 0 0 8px 2px rgba(250, 204, 21, 0.6); }
    .card-status { position: absolute; left: 1.2rem; bottom: 1rem; font-size: 0.7rem; color: #e2e8f0; display: flex; align-items: center; }
    .card-status span:last-child { text-shadow: var(--status-glow); }
    .card-button { position: absolute; right: 1.2rem; bottom: 1rem; }
    .visit-btn { background: rgba(0, 0, 0, var(--btn-opacity)); backdrop-filter: blur(12px); border: 1px solid rgba(0, 0, 0, var(--btn-opacity)); color: #ffffff; border-radius: 6px; padding: 0.35rem 0.9rem; font-size: 0.7rem; font-weight: 500; cursor: pointer; transition: all 0.4s ease; text-decoration: none; display: inline-block; box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1); }
    .visit-btn:hover { background: rgba(0, 0, 0, var(--btn-hover-opacity)); border-color: rgba(0, 0, 0, var(--btn-hover-opacity)); transform: scale(1.08); box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2); }
    header h1 { color: #ffffff; }
    header p { color: #ededed; }
    @media (max-width: 1200px) { .main-container { width: 70%; grid-template-columns: repeat(3, 1fr); } }
    @media (max-width: 992px) { .main-container { width: 80%; grid-template-columns: repeat(2, 1fr); } }
    @media (max-width: 700px) { .main-container { width: 90%; grid-template-columns: 1fr; } .website-card { min-height: 100px; } }
    </style>
</head>
<body>
    <header class="text-center py-6">
        <h1 class="text-3xl font-bold mb-2"><?= htmlspecialchars($data['mainTitle']) ?></h1>
        <p class="text-sm"><?= htmlspecialchars($data['subTitle']) ?></p>
    </header>

    <div class="main-container" id="website-container">
        <?php if (!empty($data['websites'])): ?>
            <?php foreach ($data['websites'] as $site): ?>
                <div class="website-card" data-url="<?= htmlspecialchars($site['url']) ?>">
                    <img class="website-icon" src="icons/<?= rawurlencode($site['title']) ?>.ico?t=<?= time() ?>" alt="<?= htmlspecialchars($site['title']) ?> 图标">
                    <div class="card-content">
                        <h3 class="website-title"><?= htmlspecialchars($site['title']) ?></h3>
                        <p class="website-desc"><?= htmlspecialchars($site['description']) ?></p>
                    </div>
                    <div class="card-status">
                        <span class="status-indicator status-checking"></span>
                        <span>检测中...</span>
                    </div>
                    <div class="card-button">
                        <a href="<?= htmlspecialchars($site['url']) ?>" target="_blank" rel="noopener noreferrer" class="visit-btn">访问</a>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <p class="text-center col-span-3">还没有添加任何网站，请前往后台管理。</p>
        <?php endif; ?>
    </div>

    <script>
        const wallpaperCount = <?= count(glob('images/background*.jpg')) ?>;

        function setRandomBackground() {
            if (wallpaperCount > 0) {
                const randomNum = Math.floor(Math.random() * wallpaperCount) + 1;
                document.documentElement.style.setProperty('--bg-image', `url('./images/background${randomNum}.jpg')`);
            }
        }

        window.addEventListener('DOMContentLoaded', () => {
            setRandomBackground();
            document.querySelectorAll('.website-card').forEach(card => {
                initWebsiteCard(card, card.dataset.url);
            });
        });

        async function initWebsiteCard(card, url) {
            const iconImg = card.querySelector('.website-icon');
            iconImg.onerror = () => {
                iconImg.src = 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIHZpZXdCb3g9IjAgMCA0OCA0OCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMjQiIGN5PSIyNCIgcj0iMjQiIGZpbGw9IiM0NTQ1NDUiLz4KPGNpcmNsZSBjeD0iMjQiIGN5PSIyNCIgcj0iMTgiIGZpbGw9IndoaXRlIi8+CjxwYXRoIGQ9Ik0yNCAxM0g0MCIgc3Ryb2tlPSIjZTBlMGUwIiBzdHJva2Utd2lkdGg9IjIiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPgo8cGF0aCBkPSJNMjQgMTlINDAiIHN0cm9rZT0iI2UwZTBlMCIgc3Ryb2tlLXdpZHRoPSIyIiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPHBhdGggZD0iTTI0IDI1SDQwIiBzdHJva2U9IiNlMGUwZTAiIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMiAxM0g0IiBzdHJva2U9IiNlMGUwZTAiIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMiAxOUg0IiBzdHJva2U9IiNlMGUwZTAiIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMiAyNUg0IiBzdHJva2U9IiNlMGUwZTAiIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+Cjwvc3ZnPgo=';
            };
            checkWebsiteStatus(card, url);
        }

        async function checkWebsiteStatus(card, url) {
            const statusIndicator = card.querySelector('.status-indicator');
            const statusText = statusIndicator.nextElementSibling;
            try {
                const checkUrl = new URL(url);
                const controller = new AbortController();
                const timeoutId = setTimeout(() => controller.abort(), 5000);
                
                const startTime = performance.now();
                await fetch(checkUrl, { method: 'HEAD', mode: 'no-cors', signal: controller.signal });
                clearTimeout(timeoutId);
                const delay = Math.round(performance.now() - startTime);
                
                statusIndicator.className = 'status-indicator status-online';
                statusText.textContent = `在线 (${delay}ms)`;
            } catch (error) {
                statusIndicator.className = 'status-indicator status-offline';
                statusText.textContent = '离线';
            }
        }
    </script>
</body>
</html>
