<?php
require_once 'config.php';
$conn = get_db_connection();

// 获取配置
$sql = "SELECT * FROM `config`";
$result = $conn->query($sql);

$config = array();
if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $config[$row["key"]] = $row["value"];
    }
}

// 获取线路
$sql = "SELECT * FROM `lines`";
$result = $conn->query($sql);

$lines = array();
if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $lines[] = $row;
    }
}

// 获取友情链接
$sql = "SELECT * FROM `friend_links`";
$result = $conn->query($sql);

$friendLinks = array();
if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $friendLinks[] = $row;
    }
}

$conn->close();

// 构建响应
$response = array(
    "siteName" => isset($config["site_name"]) ? $config["site_name"] : "视频解析",
    "siteLogo" => isset($config["site_logo"]) ? $config["site_logo"] : "",
    "siteDescription" => isset($config["site_description"]) ? $config["site_description"] : "",
    "backgroundImage" => isset($config["background_image"]) ? $config["background_image"] : "https://www.qhdh.top/png/background3.jpg",
    "recordInfo" => isset($config["record_info"]) ? $config["record_info"] : "京ICP备12345678号",
    "lines" => $lines,
    "friendLinks" => $friendLinks
);

// 设置JSON响应头
header('Content-Type: application/json');
echo json_encode($response);
?>
