<?php
// 自动引导安装逻辑
if (!file_exists('install.lock')) {
    header("Location: install.php");
    exit;
}

require_once 'config.php';
$conn = get_db_connection();

// 获取配置
$sql = "SELECT * FROM `config`";
$result = $conn->query($sql);

$config = array();
if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $config[$row["key"]] = $row["value"];
    }
}

// 获取线路
$sql = "SELECT * FROM `lines`";
$result = $conn->query($sql);

$lines = array();
if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $lines[] = $row;
    }
}

// 获取友情链接
$sql = "SELECT * FROM `friend_links`";
$result = $conn->query($sql);

$friendLinks = array();
if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $friendLinks[] = $row;
    }
}

// 获取导航链接
$sql = "SELECT * FROM `nav_links`";
$result = $conn->query($sql);

$navLinks = array();
if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $navLinks[] = $row;
    }
} else {
    // 如果没有导航链接，添加默认的
    $navLinks = array(
        array("name" => "首页", "url" => "#"),
        array("name" => "使用帮助", "url" => "#"),
        array("name" => "关于我们", "url" => "#")
    );
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($config["site_name"]) ? $config["site_name"] : "视频解析"; ?></title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: url('<?php echo isset($config["background_image"]) ? $config["background_image"] : "https://www.qhdh.top/png/background3.jpg"; ?>') no-repeat center center fixed;
            background-size: cover;
            color: #fff;
            font-family: 'Microsoft YaHei', sans-serif;
        }

        .container {
            width: 80%;
            margin: 0 auto;
        }

        header {
            padding: 20px 0;
            text-align: center;
        }

        .logo {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 20px;
        }

        nav {
            overflow-x: auto;
            white-space: nowrap;
            -webkit-overflow-scrolling: touch;
            padding: 10px 0;
        }

        nav::-webkit-scrollbar {
            display: none;
        }

        nav ul {
            display: inline-flex;
            list-style: none;
            padding: 0 10px;
        }

        nav ul li {
            margin: 0 8px; /* 调整间距，适配玻璃按钮 */
        }

        /* 导航按钮：100%纯透明玻璃效果 */
        nav ul li a {
            color: #fff;
            text-decoration: none;
            padding: 8px 16px; /* 按钮内边距，增加点击区域 */
            border-radius: 8px; /* 圆角，强化玻璃质感 */
            background: rgba(255, 255, 255, 0); /* 100%纯透明背景 */
            border: 1px solid rgba(255, 255, 255, 0.2); /* 半透明白色边框 */
            backdrop-filter: blur(10px); /* 毛玻璃模糊核心属性 */
            -webkit-backdrop-filter: blur(10px); /* 兼容移动端 */
            transition: all 0.3s ease; /* 过渡动画 */
            display: inline-block; /* 保证padding生效 */
        }

        /* 导航按钮hover：放大+发光+强化玻璃效果 */
        nav ul li a:hover {
            transform: scale(1.08); /* 轻微放大 */
            text-shadow: 0 0 12px rgba(255, 255, 255, 0.9); /* 发光效果 */
            border-color: rgba(255, 255, 255, 0.4); /* 边框更明显 */
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1); /* 轻微阴影，增强立体感 */
        }

        /* 友情链接按钮：100%纯透明玻璃效果 */
        .friend-links a {
            color: #fff;
            text-decoration: none;
            margin: 0 8px;
            padding: 6px 14px; /* 适配底部按钮尺寸 */
            border-radius: 6px;
            background: rgba(255, 255, 255, 0); /* 100%纯透明 */
            border: 1px solid rgba(255, 255, 255, 0.2);
            backdrop-filter: blur(8px);
            -webkit-backdrop-filter: blur(8px);
            transition: all 0.3s ease;
            display: inline-block;
        }

        /* 友情链接hover：放大+发光 */
        .friend-links a:hover {
            transform: scale(1.05);
            text-shadow: 0 0 10px rgba(255, 255, 255, 0.8);
            border-color: rgba(255, 255, 255, 0.4);
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }

        .main-content {
            margin-top: 50px;
        }

        .player-container {
            background: rgba(255, 255, 255, 0.1);
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            text-align: center;
            width: 70%;
            margin: 0 auto;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        #player-title {
            text-align: left; 
            margin-bottom: 10px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        /* 播放器容器：相对定位，用于加载层/提示层绝对定位 */
        .player-wrap {
            position: relative;
            width: 100%;
            height: 400px;
            border-radius: 5px;
        }

        /* 播放器：默认全透明，不再是黑色 */
        #player {
            width: 100%;
            height: 100%;
            background: transparent; /* 核心：全透明 */
            border-radius: 5px;
            border: none;
        }

        /* 未解析提示层：默认显示，居中显示"请输入视频网址" */
        .empty-tip {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            display: flex;
            justify-content: center;
            align-items: center;
            color: rgba(255, 255, 255, 0.8); /* 文字半透，更美观 */
            font-size: 20px;
            z-index: 98; /* 低于加载层，高于播放器 */
        }

        /* 加载层：默认隐藏，居中显示加载图片（和播放器同尺寸） */
        .loading-layer {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.1); /* 轻微遮罩，突出加载图 */
            backdrop-filter: blur(5px);
            display: none; /* 默认隐藏 */
            justify-content: center;
            align-items: center;
            z-index: 99; /* 确保在播放器和提示层上层 */
        }

        /* 加载图片样式：和播放器完全同尺寸，不拉伸变形 */
        .loading-layer img {
            width: 100%;
            height: 100%;
            object-fit: cover; /* 铺满容器且保持比例，可选contain（完整显示） */
            border-radius: 5px;
        }

        .input-container {
            display: flex;
            margin-top: 20px;
        }

        #video-url {
            flex: 1;
            padding: 10px;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 5px;
            color: #fff;
            margin-right: 10px;
        }

        .btn {
            padding: 10px 20px;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 5px;
            color: #fff;
            cursor: pointer;
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
        }

        .btn:hover {
            background: rgba(255, 255, 255, 0.2);
        }

        .line-selector {
            margin-left: 10px;
        }

        #line-select {
            padding: 10px;
            background: rgba(0, 0, 0, 0.5);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 5px;
            color: #fff;
            min-width: 120px;
        }

        footer {
            margin-top: 100px;
            padding: 20px 0;
            text-align: center;
        }

        .friend-links, .record-info {
            margin-bottom: 10px;
        }

        .login-btn {
            padding: 10px 20px;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 5px;
            color: #fff;
            cursor: pointer;
            text-decoration: none;
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
        }

        /* 响应式设计 */
        @media (max-width: 768px) {
            .container {
                width: 95%;
            }
            .player-container {
                width: 95%;
            }
            .input-container {
                flex-direction: column;
            }
            .line-selector {
                margin-left: 0;
                margin-top: 10px;
            }
            #line-select {
                width: 100%;
            }
            /* 移动端导航按钮适配 */
            nav ul li a {
                padding: 6px 12px;
                font-size: 14px;
            }
            /* 移动端友情链接按钮适配 */
            .friend-links a {
                padding: 4px 10px;
                font-size: 13px;
            }
            /* 移动端播放器高度适配 */
            .player-wrap {
                height: 250px;
            }
            /* 移动端提示文字缩小 */
            .empty-tip {
                font-size: 16px;
            }
        }

        @media (min-width: 769px) and (max-width: 1024px) {
            .player-container {
                width: 70%;
            }
            .player-wrap {
                height: 300px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <header>
            <div class="logo" id="site-logo">
                <?php if (isset($config["site_logo"]) && !empty($config["site_logo"])) { ?>
                    <img src="<?php echo $config["site_logo"]; ?>" alt="<?php echo isset($config["site_name"]) ? $config["site_name"] : "视频解析"; ?>" style="height: 40px;">
                <?php } else { ?>
                    <?php echo isset($config["site_name"]) ? $config["site_name"] : "视频解析"; ?>
                <?php } ?>
            </div>
            <nav>
                <ul>
                    <?php foreach ($navLinks as $navLink) { ?>
                        <li><a href="<?php echo $navLink["url"]; ?>"><?php echo $navLink["name"]; ?></a></li>
                    <?php } ?>
                </ul>
            </nav>
        </header>

        <div class="main-content">
            <div class="player-container">
                <div id="player-title" style="text-align: left; margin-bottom: 10px;">正在播放: <span id="tittext"></span></div>
                
                <!-- 播放器容器 + 提示层 + 加载层 + 播放器 -->
                <div class="player-wrap">
                    <!-- 未解析提示层：显示"请输入视频网址" -->
                    <div class="empty-tip" id="emptyTip">请输入视频网址</div>
                    <!-- 加载层：显示/123.jpg（和播放器同尺寸） -->
                    <div class="loading-layer" id="loadingLayer">
                        <img src="/123.jpg" alt="加载中...">
                    </div>
                    <!-- 播放器：默认全透明 -->
                    <iframe id="player" src="" allowtransparency="true" frameborder="0" scrolling="no" allowfullscreen="true"></iframe>
                </div>

                <div class="input-container">
                    <input type="text" id="video-url" placeholder="请输入视频链接">
                    <button class="btn" onclick="parseVideo()">解析</button>
                    <div class="line-selector">
                        <select id="line-select">
                            <?php foreach ($lines as $line) { ?>
                                <option value="<?php echo $line["id"]; ?>"><?php echo $line["name"]; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>
            </div>
        </div>

        <footer>
            <div class="friend-links" id="friend-links">
                <?php foreach ($friendLinks as $link) { ?>
                    <a href="<?php echo $link["url"]; ?>" target="_blank"><?php echo $link["name"]; ?></a>
                <?php } ?>
            </div>
            <div class="record-info" id="record-info">
                备案信息：<?php echo isset($config["record_info"]) ? $config["record_info"] : "京ICP备12345678号"; ?>
            </div>
            <div style="margin-top: 15px; font-size: 14px; color: rgba(255,255,255,0.6);">
                推荐导航：<a href="https://www.qhdh.top" target="_blank" style="color: #00d4ff; text-decoration: none; font-weight: bold;">青禾导航 (www.qhdh.top)</a>
            </div>
        </footer>
    </div>

    <script>
        // 获取核心元素
        const loadingLayer = document.getElementById('loadingLayer');
        const emptyTip = document.getElementById('emptyTip');
        
        function parseVideo() {
            const url = document.getElementById('video-url').value;
            const line = document.getElementById('line-select').value;
            if (!url) {
                alert('请输入视频链接');
                return;
            }

            // 1. 隐藏未解析提示层，显示加载层
            emptyTip.style.display = 'none';
            loadingLayer.style.display = 'flex';
            // 清空播放器标题
            document.getElementById('tittext').textContent = '加载中...';

            const api = document.getElementById('line-select').options[document.getElementById('line-select').selectedIndex].text;

            // 发送请求到后端解析视频
            fetch('parse_video.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({ url, line }),
            })
            .then(response => response.json())
            .then(data => {
                // 2. 隐藏加载层
                loadingLayer.style.display = 'none';
                
                if (data.success) {
                    const player = document.getElementById('player');
                    player.src = data.videoUrl;
                    // 尝试注入广告拦截脚本
                    player.onload = function() {
                        try {
                            const iframeDocument = player.contentDocument || player.contentWindow.document;
                            // 屏蔽所有点击事件
                            iframeDocument.addEventListener('click', function(e) {
                                e.preventDefault();
                                e.stopPropagation();
                                return false;
                            }, true);
                            // 移除所有广告图片
                            const ads = iframeDocument.querySelectorAll('img[src*="ad"], img[alt*="ad"], .ad, .advertisement');
                            ads.forEach(ad => ad.remove());
                        } catch (err) {
                            console.log('广告拦截脚本注入失败，可能存在跨域限制');
                        }
                    };
                    document.getElementById('tittext').textContent = data.title || '未知标题';
                } else {
                    // 解析失败：重新显示提示层
                    emptyTip.style.display = 'flex';
                    alert('解析失败：' + data.message);
                    document.getElementById('tittext').textContent = '解析失败';
                }
            })
            .catch((error) => {
                // 3. 加载异常：隐藏加载层，重新显示提示层
                loadingLayer.style.display = 'none';
                emptyTip.style.display = 'flex';
                console.error('Error:', error);
                alert('解析失败: ' + error);
                document.getElementById('tittext').textContent = '解析失败';
            });
        }
    </script>
</body>
</html>
