<?php
session_start(); // 必须置顶，无任何前置输出
header('Content-Type: text/html; charset=utf-8'); // 优先返回HTML，兼容表单+JSON

// 1. 已登录则直接跳后台
if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true) {
    header("Location: hou.php");
    exit;
}

// 2. 处理POST登录请求（仅表单提交时执行）
$error_msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // 获取并过滤表单数据
    $username = trim($_POST['username'] ?? '');
    $password = trim($_POST['password'] ?? '');
    
    // 空值校验
    if (empty($username) || empty($password)) {
        $error_msg = '请输入账号和密码！';
    } else {
        // 数据库连接（使用你的配置）
        require_once "config.php";
        
        $conn = get_db_connection();
        if ($conn->connect_error) {
            $error_msg = '数据库连接失败：' . $conn->connect_error;
        } else {
            // 预处理查询，防注入
            $stmt = $conn->prepare("SELECT id, password FROM admin_users WHERE username = ? LIMIT 1");
            $stmt->bind_param("s", $username);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if ($result->num_rows === 0) {
                $error_msg = '用户不存在！';
            } else {
                // 验证密码（匹配数据库中加密后的密码）
                $row = $result->fetch_assoc();
                if (password_verify($password, $row['password'])) {
                    // 登录成功，写入session
                    $_SESSION['loggedin'] = true;
                    $_SESSION['admin_id'] = $row['id'];
                    $_SESSION['username'] = $username;
                    header("Location: hou.php");
                    exit;
                } else {
                    $error_msg = '密码错误！';
                }
            }
            $stmt->close();
            $conn->close();
        }
    }
}

// 3. 未提交POST时，显示登录表单
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>管理员登录</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { 
            background: url('https://www.qhdh.top/png/background3.jpg') no-repeat center center fixed;
            background-size: cover;
            font-family: 'Microsoft YaHei', sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }
        .login-box {
            background: rgba(0,0,0,0.7);
            padding: 40px;
            border-radius: 10px;
            width: 100%;
            max-width: 400px;
            color: #fff;
        }
        .login-box h2 {
            text-align: center;
            margin-bottom: 30px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-group label {
            display: block;
            margin-bottom: 8px;
        }
        .form-group input {
            width: 100%;
            padding: 12px;
            border: 1px solid rgba(255,255,255,0.2);
            border-radius: 5px;
            background: rgba(255,255,255,0.1);
            color: #fff;
            font-size: 16px;
        }
        .form-group input::placeholder {
            color: rgba(255,255,255,0.5);
        }
        .btn {
            width: 100%;
            padding: 12px;
            border: none;
            border-radius: 5px;
            background: rgba(255,255,255,0.2);
            color: #fff;
            font-size: 16px;
            cursor: pointer;
            transition: background 0.3s;
        }
        .btn:hover {
            background: rgba(255,255,255,0.3);
        }
        .error-msg {
            color: #ff4444;
            text-align: center;
            margin-bottom: 20px;
            padding: 10px;
            border-radius: 5px;
            background: rgba(255,0,0,0.1);
        }
    </style>
</head>
<body>
    <div class="login-box">
        <h2>管理员登录</h2>
        <?php if (!empty($error_msg)) : ?>
            <div class="error-msg"><?php echo $error_msg; ?></div>
        <?php endif; ?>
        <form method="POST" action="login.php">
            <div class="form-group">
                <label for="username">账号</label>
                <input type="text" id="username" name="username" placeholder="请输入账号" required>
            </div>
            <div class="form-group">
                <label for="password">密码</label>
                <input type="password" id="password" name="password" placeholder="请输入密码" required>
            </div>
            <button type="submit" class="btn">登录</button>
        </form>
    </div>
</body>
</html>