<?php
session_start();
header('Content-Type: application/json');

// 检查是否登录
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    echo json_encode(array("success" => false, "message" => "未登录"));
    exit;
}

// 数据库连接信息
require_once "config.php";

// 创建连接
$conn = get_db_connection();

// 检查连接
if ($conn->connect_error) {
    die("连接失败: " . $conn->connect_error);
}

// 获取POST数据
$json = file_get_contents('php://input');
$data = json_decode($json, true);

$links = $data['links'];

// 清空现有的导航链接
$sql = "TRUNCATE TABLE `nav_links`";
if ($conn->query($sql) !== TRUE) {
    echo json_encode(array("success" => false, "message" => "清空导航链接失败"));
    $conn->close();
    exit;
}

// 插入新的导航链接
foreach ($links as $link) {
    $name = $conn->real_escape_string($link['name']);
    $url = $conn->real_escape_string($link['url']);
    $sql = "INSERT INTO `nav_links` (`name`, `url`) VALUES ('$name', '$url')";
    if ($conn->query($sql) !== TRUE) {
        echo json_encode(array("success" => false, "message" => "插入导航链接失败"));
        $conn->close();
        exit;
    }
}

echo json_encode(array("success" => true));

$conn->close();